/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.ModelLibrary;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

class LibraryImpl
extends PluginElementImpl
implements Library {
    private final ModelLibrary model;
    private List exports;

    LibraryImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelLibrary modelLibrary) throws ManifestProcessingException {
        super(pluginDescriptorImpl, pluginFragmentImpl, modelLibrary.getId(), modelLibrary.getDocumentation());
        this.model = modelLibrary;
        if (this.model.getPath() == null || this.model.getPath().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "libraryPathIsBlank");
        }
        this.exports = new ArrayList(this.model.getExports().size());
        Iterator iterator = this.model.getExports().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.trim().length() == 0) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "exportPrefixIBlank");
            }
            if ((string = string.replace('\\', '.').replace('/', '.')).startsWith(".")) {
                string = string.substring(1);
            }
            this.exports.add(string);
        }
        this.exports = Collections.unmodifiableList(this.exports);
        this.log.debug("object instantiated: " + this);
    }

    public String getPath() {
        return this.model.getPath();
    }

    public Collection getExports() {
        return this.exports;
    }

    public boolean isCodeLibrary() {
        return this.model.isCodeLibrary();
    }

    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    public String toString() {
        return "{Library: uid=" + this.getUniqueId() + "}";
    }

    public Version getVersion() {
        return this.model.getVersion();
    }
}

